"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleKibanaCapabilities = handleKibanaCapabilities;
exports.kibanaCapabilitiesRoute = kibanaCapabilitiesRoute;
var _configSchema = require("@kbn/config-schema");
var _wrap_elasticsearch_error = require("../../../utils/wrap_elasticsearch_error");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may//  obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function handleKibanaCapabilities() {
  return function (context, request, response) {
    try {
      const defaultCapabilities = {
        navLinks: {},
        dashboard: {},
        observabilityCases: {}
      };
      for (const appName of request.body.applications) {
        defaultCapabilities[appName] = {};
        defaultCapabilities.navLinks[appName] = true;
      }
      return response.ok({
        body: defaultCapabilities
      });
    } catch (error) {
      console.error(error);
      return response.customError((0, _wrap_elasticsearch_error.wrapForCustomError)(error));
    }
  };
}
function kibanaCapabilitiesRoute({
  router
}) {
  const options = {
    path: '/api/v1/searchguard/kibana_capabilities',
    options: {
      authRequired: false
    },
    validate: {
      body: _configSchema.schema.object({
        applications: _configSchema.schema.arrayOf(_configSchema.schema.string())
      })
    }
  };
  router.post(options, handleKibanaCapabilities());
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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